# -*- coding: utf-8 -*-
# @Author  : Doubebly
# @Time    : 2025/3/23 21:55
# import base64
import sys
import time
import json
import requests
sys.path.append('..')
from base.spider import Spider


class Spider(Spider):
    def getName(self):
        return "Tvfix"

    def init(self, extend):
        pass

    def getDependence(self):
        return []

    def isVideoFormat(self, url):
        pass

    def manualVideoCheck(self):
        pass


    def liveContent(self, url):
        url = 'https://iptv.tvfix.org/channels.json'
        headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'}
        response = requests.get(url, headers=headers)
        tv_list = json.loads(response.content)
        d = ['#EXTM3U']
        for i in tv_list['Categories']:
            for ii in i['Channels']:
                d.append(f"#EXTINF:-1 tvg-id=\"{ii['Vid']}\" tvg-name=\"{ii['Name']}\" group-title=\"{i['Name']}\",{ii['Name']}")
                d.append(f'https://live.tvfix.org/live/{i["Vid"]}/index.m3u8')
        return '\n'.join(d)

    def homeContent(self, filter):
        return {}

    def homeVideoContent(self):
        return {}

    def categoryContent(self, cid, page, filter, ext):
        return {}

    def detailContent(self, did):
        return {}

    def searchContent(self, key, quick, page='1'):
        return {}

    def searchContentPage(self, keywords, quick, page):
        return {}

    def playerContent(self, flag, pid, vipFlags):
        return {}

    def localProxy(self, params):
        return [302, "text/plain", None, {'Location': 'https://sf1-cdn-tos.huoshanstatic.com/obj/media-fe/xgplayer_doc_video/mp4/xgplayer-demo-720p.mp4'}]


    def destroy(self):
        return '正在Destroy'

if __name__ == '__main__':
    pass